/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import net.ftb.data.ModPack;
import net.ftb.data.Settings;
import net.ftb.log.Logger;

public class FileUtils {
    public static void copyFolder(File sourceFolder, File destinationFolder) throws IOException {
        FileUtils.copyFolder(sourceFolder, destinationFolder, true);
    }

    public static void copyFolder(File sourceFolder, File destinationFolder, boolean overwrite) throws IOException {
        if (sourceFolder.isDirectory()) {
            String[] files;
            if (!destinationFolder.exists()) {
                destinationFolder.mkdirs();
            }
            for (String file : files = sourceFolder.list()) {
                File srcFile = new File(sourceFolder, file);
                File destFile = new File(destinationFolder, file);
                FileUtils.copyFolder(srcFile, destFile, overwrite);
            }
        } else {
            FileUtils.copyFile(sourceFolder, destinationFolder, overwrite);
        }
    }

    public static void copyFile(File sourceFile, File destinationFile) throws IOException {
        FileUtils.copyFile(sourceFile, destinationFile, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File sourceFile, File destinationFile, boolean overwrite) throws IOException {
        if (sourceFile.exists()) {
            if (!destinationFile.exists()) {
                destinationFile.getParentFile().mkdirs();
                destinationFile.createNewFile();
            } else if (!overwrite) {
                return;
            }
            FileChannel sourceStream = null;
            AbstractInterruptibleChannel destinationStream = null;
            try {
                sourceStream = new FileInputStream(sourceFile).getChannel();
                destinationStream = new FileOutputStream(destinationFile).getChannel();
                ((FileChannel)destinationStream).transferFrom(sourceStream, 0L, sourceStream.size());
            }
            finally {
                if (sourceStream != null) {
                    sourceStream.close();
                }
                if (destinationStream != null) {
                    destinationStream.close();
                }
            }
        }
    }

    public static boolean delete(File resource) throws IOException {
        if (resource.isDirectory()) {
            File[] childFiles;
            for (File child : childFiles = resource.listFiles()) {
                FileUtils.delete(child);
            }
        }
        return resource.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void extractZipTo(String zipLocation, String outputLocation) {
        ZipInputStream zipinputstream = null;
        try {
            byte[] buf = new byte[1024];
            zipinputstream = new ZipInputStream(new FileInputStream(zipLocation));
            ZipEntry zipentry = zipinputstream.getNextEntry();
            while (zipentry != null) {
                String entryName = zipentry.getName();
                if (!(zipentry.isDirectory() || entryName.equalsIgnoreCase("minecraft") || entryName.equalsIgnoreCase(".minecraft") || entryName.equalsIgnoreCase("instMods"))) {
                    int n;
                    new File(outputLocation + File.separator + entryName).getParentFile().mkdirs();
                    FileOutputStream fileoutputstream = new FileOutputStream(outputLocation + File.separator + entryName);
                    while ((n = zipinputstream.read(buf, 0, 1024)) > -1) {
                        fileoutputstream.write(buf, 0, n);
                    }
                    fileoutputstream.close();
                }
                zipinputstream.closeEntry();
                zipentry = zipinputstream.getNextEntry();
            }
        }
        catch (Exception e) {
            Logger.logError("Error while extracting zip", e);
            FileUtils.backupExtract(zipLocation, outputLocation);
        }
        finally {
            try {
                zipinputstream.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void backupExtract(String zipLocation, String outputLocation) {
        Logger.logInfo("Extracting (Backup way)");
        byte[] buffer = new byte[1024];
        ZipInputStream zis = null;
        try {
            File folder = new File(outputLocation);
            if (!folder.exists()) {
                folder.mkdir();
            }
            zis = new ZipInputStream(new FileInputStream(zipLocation));
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                File newFile = new File(outputLocation, ze.getName());
                newFile.getParentFile().mkdirs();
                if (!ze.isDirectory()) {
                    int len;
                    FileOutputStream fos = new FileOutputStream(newFile);
                    while ((len = zis.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    fos.flush();
                    fos.close();
                }
                ze = zis.getNextEntry();
            }
        }
        catch (IOException ex) {
            Logger.logError("Error while extracting zip", ex);
        }
        finally {
            try {
                zis.closeEntry();
                zis.close();
            }
            catch (IOException e) {}
        }
    }

    public static void killMetaInf() {
        File inputFile = new File(Settings.getSettings().getInstallPath() + "/" + ModPack.getSelectedPack().getDir() + "/minecraft/bin", "minecraft.jar");
        File outputTmpFile = new File(Settings.getSettings().getInstallPath() + "/" + ModPack.getSelectedPack().getDir() + "/minecraft/bin", "minecraft.jar.tmp");
        try {
            JarEntry entry;
            JarInputStream input = new JarInputStream(new FileInputStream(inputFile));
            JarOutputStream output = new JarOutputStream(new FileOutputStream(outputTmpFile));
            while ((entry = input.getNextJarEntry()) != null) {
                int amo;
                if (entry.getName().contains("META-INF")) continue;
                output.putNextEntry(entry);
                byte[] buffer = new byte[1024];
                while ((amo = input.read(buffer, 0, 1024)) != -1) {
                    output.write(buffer, 0, amo);
                }
                output.closeEntry();
            }
            input.close();
            output.close();
            if (!inputFile.delete()) {
                Logger.logError("Failed to delete Minecraft.jar.");
                return;
            }
            outputTmpFile.renameTo(inputFile);
        }
        catch (FileNotFoundException e) {
            Logger.logError("Error while killing META-INF", e);
        }
        catch (IOException e) {
            Logger.logError("Error while killing META-INF", e);
        }
    }

    public static List<File> listDirs(File path) {
        ArrayList<File> ret = Lists.newArrayList();
        if (path.exists()) {
            FileUtils.listDirs(path, ret);
        }
        Collections.sort(ret, new Comparator<File>(){

            @Override
            public int compare(File o1, File o2) {
                return o2.compareTo(o1);
            }
        });
        return ret;
    }

    private static void listDirs(File path, List<File> list) {
        for (File f : path.listFiles()) {
            if (!f.isDirectory()) continue;
            FileUtils.listDirs(f, list);
            list.add(f);
        }
    }

    public static Set<File> listFiles(File path) {
        HashSet<File> set = Sets.newHashSet();
        if (path.exists()) {
            FileUtils.listFiles(path, set);
        }
        return set;
    }

    private static void listFiles(File path, Set<File> set) {
        for (File f : path.listFiles()) {
            if (f.isDirectory()) {
                FileUtils.listFiles(f, set);
                continue;
            }
            set.add(f);
        }
    }

    public static void move(File oldFile, File newFile) {
        try {
            if (oldFile.exists() && !newFile.exists()) {
                org.apache.commons.io.FileUtils.moveFile(oldFile, newFile);
            }
        }
        catch (IOException e) {
            Logger.logWarn("Exception occurred while moving " + oldFile.toString() + " : " + e.getMessage());
        }
    }
}

